<?php
// This file was auto-generated from sdk-root/src/data/auditmanager/2017-07-25/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2017-07-25', 'endpointPrefix' => 'auditmanager', 'jsonVersion' => '1.1', 'protocol' => 'rest-json', 'serviceFullName' => 'AWS Audit Manager', 'serviceId' => 'AuditManager', 'signatureVersion' => 'v4', 'signingName' => 'auditmanager', 'uid' => 'auditmanager-2017-07-25', ], 'operations' => [ 'AssociateAssessmentReportEvidenceFolder' => [ 'name' => 'AssociateAssessmentReportEvidenceFolder', 'http' => [ 'method' => 'PUT', 'requestUri' => '/assessments/{assessmentId}/associateToAssessmentReport', ], 'input' => [ 'shape' => 'AssociateAssessmentReportEvidenceFolderRequest', ], 'output' => [ 'shape' => 'AssociateAssessmentReportEvidenceFolderResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'BatchAssociateAssessmentReportEvidence' => [ 'name' => 'BatchAssociateAssessmentReportEvidence', 'http' => [ 'method' => 'PUT', 'requestUri' => '/assessments/{assessmentId}/batchAssociateToAssessmentReport', ], 'input' => [ 'shape' => 'BatchAssociateAssessmentReportEvidenceRequest', ], 'output' => [ 'shape' => 'BatchAssociateAssessmentReportEvidenceResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'BatchCreateDelegationByAssessment' => [ 'name' => 'BatchCreateDelegationByAssessment', 'http' => [ 'method' => 'POST', 'requestUri' => '/assessments/{assessmentId}/delegations', ], 'input' => [ 'shape' => 'BatchCreateDelegationByAssessmentRequest', ], 'output' => [ 'shape' => 'BatchCreateDelegationByAssessmentResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'BatchDeleteDelegationByAssessment' => [ 'name' => 'BatchDeleteDelegationByAssessment', 'http' => [ 'method' => 'PUT', 'requestUri' => '/assessments/{assessmentId}/delegations', ], 'input' => [ 'shape' => 'BatchDeleteDelegationByAssessmentRequest', ], 'output' => [ 'shape' => 'BatchDeleteDelegationByAssessmentResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'BatchDisassociateAssessmentReportEvidence' => [ 'name' => 'BatchDisassociateAssessmentReportEvidence', 'http' => [ 'method' => 'PUT', 'requestUri' => '/assessments/{assessmentId}/batchDisassociateFromAssessmentReport', ], 'input' => [ 'shape' => 'BatchDisassociateAssessmentReportEvidenceRequest', ], 'output' => [ 'shape' => 'BatchDisassociateAssessmentReportEvidenceResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'BatchImportEvidenceToAssessmentControl' => [ 'name' => 'BatchImportEvidenceToAssessmentControl', 'http' => [ 'method' => 'POST', 'requestUri' => '/assessments/{assessmentId}/controlSets/{controlSetId}/controls/{controlId}/evidence', ], 'input' => [ 'shape' => 'BatchImportEvidenceToAssessmentControlRequest', ], 'output' => [ 'shape' => 'BatchImportEvidenceToAssessmentControlResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateAssessment' => [ 'name' => 'CreateAssessment', 'http' => [ 'method' => 'POST', 'requestUri' => '/assessments', ], 'input' => [ 'shape' => 'CreateAssessmentRequest', ], 'output' => [ 'shape' => 'CreateAssessmentResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateAssessmentFramework' => [ 'name' => 'CreateAssessmentFramework', 'http' => [ 'method' => 'POST', 'requestUri' => '/assessmentFrameworks', ], 'input' => [ 'shape' => 'CreateAssessmentFrameworkRequest', ], 'output' => [ 'shape' => 'CreateAssessmentFrameworkResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateAssessmentReport' => [ 'name' => 'CreateAssessmentReport', 'http' => [ 'method' => 'POST', 'requestUri' => '/assessments/{assessmentId}/reports', ], 'input' => [ 'shape' => 'CreateAssessmentReportRequest', ], 'output' => [ 'shape' => 'CreateAssessmentReportResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'CreateControl' => [ 'name' => 'CreateControl', 'http' => [ 'method' => 'POST', 'requestUri' => '/controls', ], 'input' => [ 'shape' => 'CreateControlRequest', ], 'output' => [ 'shape' => 'CreateControlResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteAssessment' => [ 'name' => 'DeleteAssessment', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/assessments/{assessmentId}', ], 'input' => [ 'shape' => 'DeleteAssessmentRequest', ], 'output' => [ 'shape' => 'DeleteAssessmentResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteAssessmentFramework' => [ 'name' => 'DeleteAssessmentFramework', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/assessmentFrameworks/{frameworkId}', ], 'input' => [ 'shape' => 'DeleteAssessmentFrameworkRequest', ], 'output' => [ 'shape' => 'DeleteAssessmentFrameworkResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteAssessmentReport' => [ 'name' => 'DeleteAssessmentReport', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/assessments/{assessmentId}/reports/{assessmentReportId}', ], 'input' => [ 'shape' => 'DeleteAssessmentReportRequest', ], 'output' => [ 'shape' => 'DeleteAssessmentReportResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'DeleteControl' => [ 'name' => 'DeleteControl', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/controls/{controlId}', ], 'input' => [ 'shape' => 'DeleteControlRequest', ], 'output' => [ 'shape' => 'DeleteControlResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeregisterAccount' => [ 'name' => 'DeregisterAccount', 'http' => [ 'method' => 'POST', 'requestUri' => '/account/deregisterAccount', ], 'input' => [ 'shape' => 'DeregisterAccountRequest', ], 'output' => [ 'shape' => 'DeregisterAccountResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'DeregisterOrganizationAdminAccount' => [ 'name' => 'DeregisterOrganizationAdminAccount', 'http' => [ 'method' => 'POST', 'requestUri' => '/account/deregisterOrganizationAdminAccount', ], 'input' => [ 'shape' => 'DeregisterOrganizationAdminAccountRequest', ], 'output' => [ 'shape' => 'DeregisterOrganizationAdminAccountResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'DisassociateAssessmentReportEvidenceFolder' => [ 'name' => 'DisassociateAssessmentReportEvidenceFolder', 'http' => [ 'method' => 'PUT', 'requestUri' => '/assessments/{assessmentId}/disassociateFromAssessmentReport', ], 'input' => [ 'shape' => 'DisassociateAssessmentReportEvidenceFolderRequest', ], 'output' => [ 'shape' => 'DisassociateAssessmentReportEvidenceFolderResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetAccountStatus' => [ 'name' => 'GetAccountStatus', 'http' => [ 'method' => 'GET', 'requestUri' => '/account/status', ], 'input' => [ 'shape' => 'GetAccountStatusRequest', ], 'output' => [ 'shape' => 'GetAccountStatusResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], ], ], 'GetAssessment' => [ 'name' => 'GetAssessment', 'http' => [ 'method' => 'GET', 'requestUri' => '/assessments/{assessmentId}', ], 'input' => [ 'shape' => 'GetAssessmentRequest', ], 'output' => [ 'shape' => 'GetAssessmentResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetAssessmentFramework' => [ 'name' => 'GetAssessmentFramework', 'http' => [ 'method' => 'GET', 'requestUri' => '/assessmentFrameworks/{frameworkId}', ], 'input' => [ 'shape' => 'GetAssessmentFrameworkRequest', ], 'output' => [ 'shape' => 'GetAssessmentFrameworkResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetAssessmentReportUrl' => [ 'name' => 'GetAssessmentReportUrl', 'http' => [ 'method' => 'GET', 'requestUri' => '/assessments/{assessmentId}/reports/{assessmentReportId}/url', ], 'input' => [ 'shape' => 'GetAssessmentReportUrlRequest', ], 'output' => [ 'shape' => 'GetAssessmentReportUrlResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetChangeLogs' => [ 'name' => 'GetChangeLogs', 'http' => [ 'method' => 'GET', 'requestUri' => '/assessments/{assessmentId}/changelogs', ], 'input' => [ 'shape' => 'GetChangeLogsRequest', ], 'output' => [ 'shape' => 'GetChangeLogsResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetControl' => [ 'name' => 'GetControl', 'http' => [ 'method' => 'GET', 'requestUri' => '/controls/{controlId}', ], 'input' => [ 'shape' => 'GetControlRequest', ], 'output' => [ 'shape' => 'GetControlResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetDelegations' => [ 'name' => 'GetDelegations', 'http' => [ 'method' => 'GET', 'requestUri' => '/delegations', ], 'input' => [ 'shape' => 'GetDelegationsRequest', ], 'output' => [ 'shape' => 'GetDelegationsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetEvidence' => [ 'name' => 'GetEvidence', 'http' => [ 'method' => 'GET', 'requestUri' => '/assessments/{assessmentId}/controlSets/{controlSetId}/evidenceFolders/{evidenceFolderId}/evidence/{evidenceId}', ], 'input' => [ 'shape' => 'GetEvidenceRequest', ], 'output' => [ 'shape' => 'GetEvidenceResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetEvidenceByEvidenceFolder' => [ 'name' => 'GetEvidenceByEvidenceFolder', 'http' => [ 'method' => 'GET', 'requestUri' => '/assessments/{assessmentId}/controlSets/{controlSetId}/evidenceFolders/{evidenceFolderId}/evidence', ], 'input' => [ 'shape' => 'GetEvidenceByEvidenceFolderRequest', ], 'output' => [ 'shape' => 'GetEvidenceByEvidenceFolderResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetEvidenceFolder' => [ 'name' => 'GetEvidenceFolder', 'http' => [ 'method' => 'GET', 'requestUri' => '/assessments/{assessmentId}/controlSets/{controlSetId}/evidenceFolders/{evidenceFolderId}', ], 'input' => [ 'shape' => 'GetEvidenceFolderRequest', ], 'output' => [ 'shape' => 'GetEvidenceFolderResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetEvidenceFoldersByAssessment' => [ 'name' => 'GetEvidenceFoldersByAssessment', 'http' => [ 'method' => 'GET', 'requestUri' => '/assessments/{assessmentId}/evidenceFolders', ], 'input' => [ 'shape' => 'GetEvidenceFoldersByAssessmentRequest', ], 'output' => [ 'shape' => 'GetEvidenceFoldersByAssessmentResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetEvidenceFoldersByAssessmentControl' => [ 'name' => 'GetEvidenceFoldersByAssessmentControl', 'http' => [ 'method' => 'GET', 'requestUri' => '/assessments/{assessmentId}/evidenceFolders-by-assessment-control/{controlSetId}/{controlId}', ], 'input' => [ 'shape' => 'GetEvidenceFoldersByAssessmentControlRequest', ], 'output' => [ 'shape' => 'GetEvidenceFoldersByAssessmentControlResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetOrganizationAdminAccount' => [ 'name' => 'GetOrganizationAdminAccount', 'http' => [ 'method' => 'GET', 'requestUri' => '/account/organizationAdminAccount', ], 'input' => [ 'shape' => 'GetOrganizationAdminAccountRequest', ], 'output' => [ 'shape' => 'GetOrganizationAdminAccountResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetServicesInScope' => [ 'name' => 'GetServicesInScope', 'http' => [ 'method' => 'GET', 'requestUri' => '/services', ], 'input' => [ 'shape' => 'GetServicesInScopeRequest', ], 'output' => [ 'shape' => 'GetServicesInScopeResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetSettings' => [ 'name' => 'GetSettings', 'http' => [ 'method' => 'GET', 'requestUri' => '/settings/{attribute}', ], 'input' => [ 'shape' => 'GetSettingsRequest', ], 'output' => [ 'shape' => 'GetSettingsResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListAssessmentFrameworks' => [ 'name' => 'ListAssessmentFrameworks', 'http' => [ 'method' => 'GET', 'requestUri' => '/assessmentFrameworks', ], 'input' => [ 'shape' => 'ListAssessmentFrameworksRequest', ], 'output' => [ 'shape' => 'ListAssessmentFrameworksResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListAssessmentReports' => [ 'name' => 'ListAssessmentReports', 'http' => [ 'method' => 'GET', 'requestUri' => '/assessmentReports', ], 'input' => [ 'shape' => 'ListAssessmentReportsRequest', ], 'output' => [ 'shape' => 'ListAssessmentReportsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListAssessments' => [ 'name' => 'ListAssessments', 'http' => [ 'method' => 'GET', 'requestUri' => '/assessments', ], 'input' => [ 'shape' => 'ListAssessmentsRequest', ], 'output' => [ 'shape' => 'ListAssessmentsResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListControls' => [ 'name' => 'ListControls', 'http' => [ 'method' => 'GET', 'requestUri' => '/controls', ], 'input' => [ 'shape' => 'ListControlsRequest', ], 'output' => [ 'shape' => 'ListControlsResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListKeywordsForDataSource' => [ 'name' => 'ListKeywordsForDataSource', 'http' => [ 'method' => 'GET', 'requestUri' => '/dataSourceKeywords', ], 'input' => [ 'shape' => 'ListKeywordsForDataSourceRequest', ], 'output' => [ 'shape' => 'ListKeywordsForDataSourceResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListNotifications' => [ 'name' => 'ListNotifications', 'http' => [ 'method' => 'GET', 'requestUri' => '/notifications', ], 'input' => [ 'shape' => 'ListNotificationsRequest', ], 'output' => [ 'shape' => 'ListNotificationsResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/tags/{resourceArn}', ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'RegisterAccount' => [ 'name' => 'RegisterAccount', 'http' => [ 'method' => 'POST', 'requestUri' => '/account/registerAccount', ], 'input' => [ 'shape' => 'RegisterAccountRequest', ], 'output' => [ 'shape' => 'RegisterAccountResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'RegisterOrganizationAdminAccount' => [ 'name' => 'RegisterOrganizationAdminAccount', 'http' => [ 'method' => 'POST', 'requestUri' => '/account/registerOrganizationAdminAccount', ], 'input' => [ 'shape' => 'RegisterOrganizationAdminAccountRequest', ], 'output' => [ 'shape' => 'RegisterOrganizationAdminAccountResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tags/{resourceArn}', ], 'input' => [ 'shape' => 'TagResourceRequest', ], 'output' => [ 'shape' => 'TagResourceResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tags/{resourceArn}', ], 'input' => [ 'shape' => 'UntagResourceRequest', ], 'output' => [ 'shape' => 'UntagResourceResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'UpdateAssessment' => [ 'name' => 'UpdateAssessment', 'http' => [ 'method' => 'PUT', 'requestUri' => '/assessments/{assessmentId}', ], 'input' => [ 'shape' => 'UpdateAssessmentRequest', ], 'output' => [ 'shape' => 'UpdateAssessmentResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UpdateAssessmentControl' => [ 'name' => 'UpdateAssessmentControl', 'http' => [ 'method' => 'PUT', 'requestUri' => '/assessments/{assessmentId}/controlSets/{controlSetId}/controls/{controlId}', ], 'input' => [ 'shape' => 'UpdateAssessmentControlRequest', ], 'output' => [ 'shape' => 'UpdateAssessmentControlResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UpdateAssessmentControlSetStatus' => [ 'name' => 'UpdateAssessmentControlSetStatus', 'http' => [ 'method' => 'PUT', 'requestUri' => '/assessments/{assessmentId}/controlSets/{controlSetId}/status', ], 'input' => [ 'shape' => 'UpdateAssessmentControlSetStatusRequest', ], 'output' => [ 'shape' => 'UpdateAssessmentControlSetStatusResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UpdateAssessmentFramework' => [ 'name' => 'UpdateAssessmentFramework', 'http' => [ 'method' => 'PUT', 'requestUri' => '/assessmentFrameworks/{frameworkId}', ], 'input' => [ 'shape' => 'UpdateAssessmentFrameworkRequest', ], 'output' => [ 'shape' => 'UpdateAssessmentFrameworkResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UpdateAssessmentStatus' => [ 'name' => 'UpdateAssessmentStatus', 'http' => [ 'method' => 'PUT', 'requestUri' => '/assessments/{assessmentId}/status', ], 'input' => [ 'shape' => 'UpdateAssessmentStatusRequest', ], 'output' => [ 'shape' => 'UpdateAssessmentStatusResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UpdateControl' => [ 'name' => 'UpdateControl', 'http' => [ 'method' => 'PUT', 'requestUri' => '/controls/{controlId}', ], 'input' => [ 'shape' => 'UpdateControlRequest', ], 'output' => [ 'shape' => 'UpdateControlResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UpdateSettings' => [ 'name' => 'UpdateSettings', 'http' => [ 'method' => 'PUT', 'requestUri' => '/settings', ], 'input' => [ 'shape' => 'UpdateSettingsRequest', ], 'output' => [ 'shape' => 'UpdateSettingsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ValidateAssessmentReportIntegrity' => [ 'name' => 'ValidateAssessmentReportIntegrity', 'http' => [ 'method' => 'POST', 'requestUri' => '/assessmentReports/integrity', ], 'input' => [ 'shape' => 'ValidateAssessmentReportIntegrityRequest', ], 'output' => [ 'shape' => 'ValidateAssessmentReportIntegrityResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], ], 'shapes' => [ 'AWSAccount' => [ 'type' => 'structure', 'members' => [ 'id' => [ 'shape' => 'AccountId', ], 'emailAddress' => [ 'shape' => 'EmailAddress', ], 'name' => [ 'shape' => 'AccountName', ], ], ], 'AWSAccounts' => [ 'type' => 'list', 'member' => [ 'shape' => 'AWSAccount', ], ], 'AWSService' => [ 'type' => 'structure', 'members' => [ 'serviceName' => [ 'shape' => 'AWSServiceName', ], ], ], 'AWSServiceName' => [ 'type' => 'string', 'max' => 40, 'min' => 1, 'pattern' => '^[a-zA-Z0-9-\\s().]+$', ], 'AWSServices' => [ 'type' => 'list', 'member' => [ 'shape' => 'AWSService', ], ], 'AccessDeniedException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 403, ], 'exception' => true, ], 'AccountId' => [ 'type' => 'string', 'max' => 12, 'min' => 12, 'pattern' => '^[0-9]{12}$', ], 'AccountName' => [ 'type' => 'string', 'max' => 50, 'min' => 1, 'pattern' => '^[\\u0020-\\u007E]+$', ], 'AccountStatus' => [ 'type' => 'string', 'enum' => [ 'ACTIVE', 'INACTIVE', 'PENDING_ACTIVATION', ], ], 'ActionEnum' => [ 'type' => 'string', 'enum' => [ 'CREATE', 'UPDATE_METADATA', 'ACTIVE', 'INACTIVE', 'DELETE', 'UNDER_REVIEW', 'REVIEWED', 'IMPORT_EVIDENCE', ], ], 'ActionPlanInstructions' => [ 'type' => 'string', 'max' => 1000, 'pattern' => '^[\\w\\W\\s\\S]*$', ], 'ActionPlanTitle' => [ 'type' => 'string', 'max' => 300, 'pattern' => '^[\\w\\W\\s\\S]*$', ], 'Assessment' => [ 'type' => 'structure', 'members' => [ 'arn' => [ 'shape' => 'AuditManagerArn', ], 'awsAccount' => [ 'shape' => 'AWSAccount', ], 'metadata' => [ 'shape' => 'AssessmentMetadata', ], 'framework' => [ 'shape' => 'AssessmentFramework', ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'AssessmentControl' => [ 'type' => 'structure', 'members' => [ 'id' => [ 'shape' => 'UUID', ], 'name' => [ 'shape' => 'ControlName', ], 'description' => [ 'shape' => 'ControlDescription', ], 'status' => [ 'shape' => 'ControlStatus', ], 'response' => [ 'shape' => 'ControlResponse', ], 'comments' => [ 'shape' => 'ControlComments', ], 'evidenceSources' => [ 'shape' => 'EvidenceSources', ], 'evidenceCount' => [ 'shape' => 'Integer', ], 'assessmentReportEvidenceCount' => [ 'shape' => 'Integer', ], ], ], 'AssessmentControlSet' => [ 'type' => 'structure', 'members' => [ 'id' => [ 'shape' => 'ControlSetId', ], 'description' => [ 'shape' => 'NonEmptyString', ], 'status' => [ 'shape' => 'ControlSetStatus', ], 'roles' => [ 'shape' => 'Roles', ], 'controls' => [ 'shape' => 'AssessmentControls', ], 'delegations' => [ 'shape' => 'Delegations', ], 'systemEvidenceCount' => [ 'shape' => 'Integer', ], 'manualEvidenceCount' => [ 'shape' => 'Integer', ], ], ], 'AssessmentControlSets' => [ 'type' => 'list', 'member' => [ 'shape' => 'AssessmentControlSet', ], ], 'AssessmentControls' => [ 'type' => 'list', 'member' => [ 'shape' => 'AssessmentControl', ], ], 'AssessmentDescription' => [ 'type' => 'string', 'max' => 1000, 'pattern' => '^[\\w\\W\\s\\S]*$', ], 'AssessmentEvidenceFolder' => [ 'type' => 'structure', 'members' => [ 'name' => [ 'shape' => 'AssessmentEvidenceFolderName', ], 'date' => [ 'shape' => 'Timestamp', ], 'assessmentId' => [ 'shape' => 'UUID', ], 'controlSetId' => [ 'shape' => 'ControlSetId', ], 'controlId' => [ 'shape' => 'UUID', ], 'id' => [ 'shape' => 'UUID', ], 'dataSource' => [ 'shape' => 'String', ], 'author' => [ 'shape' => 'String', ], 'totalEvidence' => [ 'shape' => 'Integer', ], 'assessmentReportSelectionCount' => [ 'shape' => 'Integer', ], 'controlName' => [ 'shape' => 'ControlName', ], 'evidenceResourcesIncludedCount' => [ 'shape' => 'Integer', ], 'evidenceByTypeConfigurationDataCount' => [ 'shape' => 'Integer', ], 'evidenceByTypeManualCount' => [ 'shape' => 'Integer', ], 'evidenceByTypeComplianceCheckCount' => [ 'shape' => 'Integer', ], 'evidenceByTypeComplianceCheckIssuesCount' => [ 'shape' => 'Integer', ], 'evidenceByTypeUserActivityCount' => [ 'shape' => 'Integer', ], 'evidenceAwsServiceSourceCount' => [ 'shape' => 'Integer', ], ], ], 'AssessmentEvidenceFolderName' => [ 'type' => 'string', 'max' => 300, 'min' => 1, 'pattern' => '^[\\w\\W\\s\\S]*$', ], 'AssessmentEvidenceFolders' => [ 'type' => 'list', 'member' => [ 'shape' => 'AssessmentEvidenceFolder', ], ], 'AssessmentFramework' => [ 'type' => 'structure', 'members' => [ 'id' => [ 'shape' => 'UUID', ], 'arn' => [ 'shape' => 'AuditManagerArn', ], 'metadata' => [ 'shape' => 'FrameworkMetadata', ], 'controlSets' => [ 'shape' => 'AssessmentControlSets', ], ], ], 'AssessmentFrameworkDescription' => [ 'type' => 'string', 'max' => 200, 'min' => 1, 'pattern' => '^[\\w\\W\\s\\S]*$', ], 'AssessmentFrameworkMetadata' => [ 'type' => 'structure', 'members' => [ 'arn' => [ 'shape' => 'AuditManagerArn', ], 'id' => [ 'shape' => 'UUID', ], 'type' => [ 'shape' => 'FrameworkType', ], 'name' => [ 'shape' => 'FrameworkName', ], 'description' => [ 'shape' => 'FrameworkDescription', ], 'logo' => [ 'shape' => 'Filename', ], 'complianceType' => [ 'shape' => 'ComplianceType', ], 'controlsCount' => [ 'shape' => 'ControlsCount', ], 'controlSetsCount' => [ 'shape' => 'ControlSetsCount', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'lastUpdatedAt' => [ 'shape' => 'Timestamp', ], ], ], 'AssessmentMetadata' => [ 'type' => 'structure', 'members' => [ 'name' => [ 'shape' => 'AssessmentName', ], 'id' => [ 'shape' => 'UUID', ], 'description' => [ 'shape' => 'AssessmentDescription', ], 'complianceType' => [ 'shape' => 'ComplianceType', ], 'status' => [ 'shape' => 'AssessmentStatus', ], 'assessmentReportsDestination' => [ 'shape' => 'AssessmentReportsDestination', ], 'scope' => [ 'shape' => 'Scope', ], 'roles' => [ 'shape' => 'Roles', ], 'delegations' => [ 'shape' => 'Delegations', ], 'creationTime' => [ 'shape' => 'Timestamp', ], 'lastUpdated' => [ 'shape' => 'Timestamp', ], ], ], 'AssessmentMetadataItem' => [ 'type' => 'structure', 'members' => [ 'name' => [ 'shape' => 'AssessmentName', ], 'id' => [ 'shape' => 'UUID', ], 'complianceType' => [ 'shape' => 'ComplianceType', ], 'status' => [ 'shape' => 'AssessmentStatus', ], 'roles' => [ 'shape' => 'Roles', ], 'delegations' => [ 'shape' => 'Delegations', ], 'creationTime' => [ 'shape' => 'Timestamp', ], 'lastUpdated' => [ 'shape' => 'Timestamp', ], ], ], 'AssessmentName' => [ 'type' => 'string', 'max' => 300, 'min' => 1, 'pattern' => '^[\\w\\W\\s\\S]*$', ], 'AssessmentReport' => [ 'type' => 'structure', 'members' => [ 'id' => [ 'shape' => 'UUID', ], 'name' => [ 'shape' => 'AssessmentReportName', ], 'description' => [ 'shape' => 'AssessmentReportDescription', ], 'awsAccountId' => [ 'shape' => 'AccountId', ], 'assessmentId' => [ 'shape' => 'UUID', ], 'assessmentName' => [ 'shape' => 'AssessmentName', ], 'author' => [ 'shape' => 'Username', ], 'status' => [ 'shape' => 'AssessmentReportStatus', ], 'creationTime' => [ 'shape' => 'Timestamp', ], ], ], 'AssessmentReportDescription' => [ 'type' => 'string', 'max' => 1000, 'pattern' => '^[\\w\\W\\s\\S]*$', ], 'AssessmentReportDestinationType' => [ 'type' => 'string', 'enum' => [ 'S3', ], ], 'AssessmentReportEvidenceError' => [ 'type' => 'structure', 'members' => [ 'evidenceId' => [ 'shape' => 'UUID', ], 'errorCode' => [ 'shape' => 'ErrorCode', ], 'errorMessage' => [ 'shape' => 'ErrorMessage', ], ], ], 'AssessmentReportEvidenceErrors' => [ 'type' => 'list', 'member' => [ 'shape' => 'AssessmentReportEvidenceError', ], ], 'AssessmentReportMetadata' => [ 'type' => 'structure', 'members' => [ 'id' => [ 'shape' => 'UUID', ], 'name' => [ 'shape' => 'AssessmentReportName', ], 'description' => [ 'shape' => 'AssessmentReportDescription', ], 'assessmentId' => [ 'shape' => 'UUID', ], 'assessmentName' => [ 'shape' => 'AssessmentName', ], 'author' => [ 'shape' => 'Username', ], 'status' => [ 'shape' => 'AssessmentReportStatus', ], 'creationTime' => [ 'shape' => 'Timestamp', ], ], ], 'AssessmentReportName' => [ 'type' => 'string', 'max' => 300, 'min' => 1, 'pattern' => '^[a-zA-Z0-9-_\\.]+$', ], 'AssessmentReportStatus' => [ 'type' => 'string', 'enum' => [ 'COMPLETE', 'IN_PROGRESS', 'FAILED', ], ], 'AssessmentReportsDestination' => [ 'type' => 'structure', 'members' => [ 'destinationType' => [ 'shape' => 'AssessmentReportDestinationType', ], 'destination' => [ 'shape' => 'S3Url', ], ], ], 'AssessmentReportsMetadata' => [ 'type' => 'list', 'member' => [ 'shape' => 'AssessmentReportMetadata', ], ], 'AssessmentStatus' => [ 'type' => 'string', 'enum' => [ 'ACTIVE', 'INACTIVE', ], ], 'AssociateAssessmentReportEvidenceFolderRequest' => [ 'type' => 'structure', 'required' => [ 'assessmentId', 'evidenceFolderId', ], 'members' => [ 'assessmentId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'assessmentId', ], 'evidenceFolderId' => [ 'shape' => 'UUID', ], ], ], 'AssociateAssessmentReportEvidenceFolderResponse' => [ 'type' => 'structure', 'members' => [], ], 'AuditManagerArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 20, 'pattern' => '^arn:.*:auditmanager:.*', ], 'BatchAssociateAssessmentReportEvidenceRequest' => [ 'type' => 'structure', 'required' => [ 'assessmentId', 'evidenceFolderId', 'evidenceIds', ], 'members' => [ 'assessmentId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'assessmentId', ], 'evidenceFolderId' => [ 'shape' => 'UUID', ], 'evidenceIds' => [ 'shape' => 'EvidenceIds', ], ], ], 'BatchAssociateAssessmentReportEvidenceResponse' => [ 'type' => 'structure', 'members' => [ 'evidenceIds' => [ 'shape' => 'EvidenceIds', ], 'errors' => [ 'shape' => 'AssessmentReportEvidenceErrors', ], ], ], 'BatchCreateDelegationByAssessmentError' => [ 'type' => 'structure', 'members' => [ 'createDelegationRequest' => [ 'shape' => 'CreateDelegationRequest', ], 'errorCode' => [ 'shape' => 'ErrorCode', ], 'errorMessage' => [ 'shape' => 'ErrorMessage', ], ], ], 'BatchCreateDelegationByAssessmentErrors' => [ 'type' => 'list', 'member' => [ 'shape' => 'BatchCreateDelegationByAssessmentError', ], ], 'BatchCreateDelegationByAssessmentRequest' => [ 'type' => 'structure', 'required' => [ 'createDelegationRequests', 'assessmentId', ], 'members' => [ 'createDelegationRequests' => [ 'shape' => 'CreateDelegationRequests', ], 'assessmentId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'assessmentId', ], ], ], 'BatchCreateDelegationByAssessmentResponse' => [ 'type' => 'structure', 'members' => [ 'delegations' => [ 'shape' => 'Delegations', ], 'errors' => [ 'shape' => 'BatchCreateDelegationByAssessmentErrors', ], ], ], 'BatchDeleteDelegationByAssessmentError' => [ 'type' => 'structure', 'members' => [ 'delegationId' => [ 'shape' => 'UUID', ], 'errorCode' => [ 'shape' => 'ErrorCode', ], 'errorMessage' => [ 'shape' => 'ErrorMessage', ], ], ], 'BatchDeleteDelegationByAssessmentErrors' => [ 'type' => 'list', 'member' => [ 'shape' => 'BatchDeleteDelegationByAssessmentError', ], ], 'BatchDeleteDelegationByAssessmentRequest' => [ 'type' => 'structure', 'required' => [ 'delegationIds', 'assessmentId', ], 'members' => [ 'delegationIds' => [ 'shape' => 'DelegationIds', ], 'assessmentId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'assessmentId', ], ], ], 'BatchDeleteDelegationByAssessmentResponse' => [ 'type' => 'structure', 'members' => [ 'errors' => [ 'shape' => 'BatchDeleteDelegationByAssessmentErrors', ], ], ], 'BatchDisassociateAssessmentReportEvidenceRequest' => [ 'type' => 'structure', 'required' => [ 'assessmentId', 'evidenceFolderId', 'evidenceIds', ], 'members' => [ 'assessmentId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'assessmentId', ], 'evidenceFolderId' => [ 'shape' => 'UUID', ], 'evidenceIds' => [ 'shape' => 'EvidenceIds', ], ], ], 'BatchDisassociateAssessmentReportEvidenceResponse' => [ 'type' => 'structure', 'members' => [ 'evidenceIds' => [ 'shape' => 'EvidenceIds', ], 'errors' => [ 'shape' => 'AssessmentReportEvidenceErrors', ], ], ], 'BatchImportEvidenceToAssessmentControlError' => [ 'type' => 'structure', 'members' => [ 'manualEvidence' => [ 'shape' => 'ManualEvidence', ], 'errorCode' => [ 'shape' => 'ErrorCode', ], 'errorMessage' => [ 'shape' => 'ErrorMessage', ], ], ], 'BatchImportEvidenceToAssessmentControlErrors' => [ 'type' => 'list', 'member' => [ 'shape' => 'BatchImportEvidenceToAssessmentControlError', ], ], 'BatchImportEvidenceToAssessmentControlRequest' => [ 'type' => 'structure', 'required' => [ 'assessmentId', 'controlSetId', 'controlId', 'manualEvidence', ], 'members' => [ 'assessmentId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'assessmentId', ], 'controlSetId' => [ 'shape' => 'ControlSetId', 'location' => 'uri', 'locationName' => 'controlSetId', ], 'controlId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'controlId', ], 'manualEvidence' => [ 'shape' => 'ManualEvidenceList', ], ], ], 'BatchImportEvidenceToAssessmentControlResponse' => [ 'type' => 'structure', 'members' => [ 'errors' => [ 'shape' => 'BatchImportEvidenceToAssessmentControlErrors', ], ], ], 'Boolean' => [ 'type' => 'boolean', ], 'ChangeLog' => [ 'type' => 'structure', 'members' => [ 'objectType' => [ 'shape' => 'ObjectTypeEnum', ], 'objectName' => [ 'shape' => 'NonEmptyString', ], 'action' => [ 'shape' => 'ActionEnum', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'createdBy' => [ 'shape' => 'IamArn', ], ], ], 'ChangeLogs' => [ 'type' => 'list', 'member' => [ 'shape' => 'ChangeLog', ], ], 'ComplianceType' => [ 'type' => 'string', 'max' => 100, 'pattern' => '^[\\w\\W\\s\\S]*$', ], 'Control' => [ 'type' => 'structure', 'members' => [ 'arn' => [ 'shape' => 'AuditManagerArn', ], 'id' => [ 'shape' => 'UUID', ], 'type' => [ 'shape' => 'ControlType', ], 'name' => [ 'shape' => 'ControlName', ], 'description' => [ 'shape' => 'ControlDescription', ], 'testingInformation' => [ 'shape' => 'TestingInformation', ], 'actionPlanTitle' => [ 'shape' => 'ActionPlanTitle', ], 'actionPlanInstructions' => [ 'shape' => 'ActionPlanInstructions', ], 'controlSources' => [ 'shape' => 'ControlSources', ], 'controlMappingSources' => [ 'shape' => 'ControlMappingSources', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'lastUpdatedAt' => [ 'shape' => 'Timestamp', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'lastUpdatedBy' => [ 'shape' => 'LastUpdatedBy', ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'ControlComment' => [ 'type' => 'structure', 'members' => [ 'authorName' => [ 'shape' => 'Username', ], 'commentBody' => [ 'shape' => 'ControlCommentBody', ], 'postedDate' => [ 'shape' => 'Timestamp', ], ], ], 'ControlCommentBody' => [ 'type' => 'string', 'max' => 500, 'pattern' => '^[\\w\\W\\s\\S]*$', ], 'ControlComments' => [ 'type' => 'list', 'member' => [ 'shape' => 'ControlComment', ], ], 'ControlDescription' => [ 'type' => 'string', 'max' => 1000, 'pattern' => '^[\\w\\W\\s\\S]*$', ], 'ControlMappingSource' => [ 'type' => 'structure', 'members' => [ 'sourceId' => [ 'shape' => 'UUID', ], 'sourceName' => [ 'shape' => 'SourceName', ], 'sourceDescription' => [ 'shape' => 'SourceDescription', ], 'sourceSetUpOption' => [ 'shape' => 'SourceSetUpOption', ], 'sourceType' => [ 'shape' => 'SourceType', ], 'sourceKeyword' => [ 'shape' => 'SourceKeyword', ], 'sourceFrequency' => [ 'shape' => 'SourceFrequency', ], 'troubleshootingText' => [ 'shape' => 'TroubleshootingText', ], ], ], 'ControlMappingSources' => [ 'type' => 'list', 'member' => [ 'shape' => 'ControlMappingSource', ], 'min' => 1, ], 'ControlMetadata' => [ 'type' => 'structure', 'members' => [ 'arn' => [ 'shape' => 'AuditManagerArn', ], 'id' => [ 'shape' => 'UUID', ], 'name' => [ 'shape' => 'ControlName', ], 'controlSources' => [ 'shape' => 'ControlSources', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'lastUpdatedAt' => [ 'shape' => 'Timestamp', ], ], ], 'ControlMetadataList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ControlMetadata', ], ], 'ControlName' => [ 'type' => 'string', 'max' => 300, 'min' => 1, 'pattern' => '^[\\w\\W\\s\\S]*$', ], 'ControlResponse' => [ 'type' => 'string', 'enum' => [ 'MANUAL', 'AUTOMATE', 'DEFER', 'IGNORE', ], ], 'ControlSet' => [ 'type' => 'structure', 'members' => [ 'id' => [ 'shape' => 'UUID', ], 'name' => [ 'shape' => 'ControlSetName', ], 'controls' => [ 'shape' => 'Controls', ], ], ], 'ControlSetId' => [ 'type' => 'string', 'max' => 300, 'min' => 1, 'pattern' => '^[\\w\\W\\s\\S]*$', ], 'ControlSetName' => [ 'type' => 'string', 'max' => 300, 'min' => 1, 'pattern' => '^[^\\_]*$', ], 'ControlSetStatus' => [ 'type' => 'string', 'enum' => [ 'ACTIVE', 'UNDER_REVIEW', 'REVIEWED', ], ], 'ControlSets' => [ 'type' => 'list', 'member' => [ 'shape' => 'ControlSet', ], 'min' => 1, ], 'ControlSetsCount' => [ 'type' => 'integer', ], 'ControlSources' => [ 'type' => 'string', 'max' => 100, 'min' => 1, 'pattern' => '^[a-zA-Z_0-9-\\s.,]+$', ], 'ControlStatus' => [ 'type' => 'string', 'enum' => [ 'UNDER_REVIEW', 'REVIEWED', 'INACTIVE', ], ], 'ControlType' => [ 'type' => 'string', 'enum' => [ 'Standard', 'Custom', ], ], 'Controls' => [ 'type' => 'list', 'member' => [ 'shape' => 'Control', ], 'min' => 1, ], 'ControlsCount' => [ 'type' => 'integer', ], 'CreateAssessmentFrameworkControl' => [ 'type' => 'structure', 'members' => [ 'id' => [ 'shape' => 'UUID', ], ], ], 'CreateAssessmentFrameworkControlSet' => [ 'type' => 'structure', 'members' => [ 'name' => [ 'shape' => 'ControlSetName', ], 'controls' => [ 'shape' => 'CreateAssessmentFrameworkControls', ], ], ], 'CreateAssessmentFrameworkControlSets' => [ 'type' => 'list', 'member' => [ 'shape' => 'CreateAssessmentFrameworkControlSet', ], 'min' => 1, ], 'CreateAssessmentFrameworkControls' => [ 'type' => 'list', 'member' => [ 'shape' => 'CreateAssessmentFrameworkControl', ], 'min' => 1, ], 'CreateAssessmentFrameworkRequest' => [ 'type' => 'structure', 'required' => [ 'name', 'controlSets', ], 'members' => [ 'name' => [ 'shape' => 'FrameworkName', ], 'description' => [ 'shape' => 'FrameworkDescription', ], 'complianceType' => [ 'shape' => 'ComplianceType', ], 'controlSets' => [ 'shape' => 'CreateAssessmentFrameworkControlSets', ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateAssessmentFrameworkResponse' => [ 'type' => 'structure', 'members' => [ 'framework' => [ 'shape' => 'Framework', ], ], ], 'CreateAssessmentReportRequest' => [ 'type' => 'structure', 'required' => [ 'name', 'assessmentId', ], 'members' => [ 'name' => [ 'shape' => 'AssessmentReportName', ], 'description' => [ 'shape' => 'AssessmentReportDescription', ], 'assessmentId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'assessmentId', ], ], ], 'CreateAssessmentReportResponse' => [ 'type' => 'structure', 'members' => [ 'assessmentReport' => [ 'shape' => 'AssessmentReport', ], ], ], 'CreateAssessmentRequest' => [ 'type' => 'structure', 'required' => [ 'name', 'assessmentReportsDestination', 'scope', 'roles', 'frameworkId', ], 'members' => [ 'name' => [ 'shape' => 'AssessmentName', ], 'description' => [ 'shape' => 'AssessmentDescription', ], 'assessmentReportsDestination' => [ 'shape' => 'AssessmentReportsDestination', ], 'scope' => [ 'shape' => 'Scope', ], 'roles' => [ 'shape' => 'Roles', ], 'frameworkId' => [ 'shape' => 'UUID', ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateAssessmentResponse' => [ 'type' => 'structure', 'members' => [ 'assessment' => [ 'shape' => 'Assessment', ], ], ], 'CreateControlMappingSource' => [ 'type' => 'structure', 'members' => [ 'sourceName' => [ 'shape' => 'SourceName', ], 'sourceDescription' => [ 'shape' => 'SourceDescription', ], 'sourceSetUpOption' => [ 'shape' => 'SourceSetUpOption', ], 'sourceType' => [ 'shape' => 'SourceType', ], 'sourceKeyword' => [ 'shape' => 'SourceKeyword', ], 'sourceFrequency' => [ 'shape' => 'SourceFrequency', ], 'troubleshootingText' => [ 'shape' => 'TroubleshootingText', ], ], ], 'CreateControlMappingSources' => [ 'type' => 'list', 'member' => [ 'shape' => 'CreateControlMappingSource', ], 'min' => 1, ], 'CreateControlRequest' => [ 'type' => 'structure', 'required' => [ 'name', 'controlMappingSources', ], 'members' => [ 'name' => [ 'shape' => 'ControlName', ], 'description' => [ 'shape' => 'ControlDescription', ], 'testingInformation' => [ 'shape' => 'TestingInformation', ], 'actionPlanTitle' => [ 'shape' => 'ActionPlanTitle', ], 'actionPlanInstructions' => [ 'shape' => 'ActionPlanInstructions', ], 'controlMappingSources' => [ 'shape' => 'CreateControlMappingSources', ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateControlResponse' => [ 'type' => 'structure', 'members' => [ 'control' => [ 'shape' => 'Control', ], ], ], 'CreateDelegationRequest' => [ 'type' => 'structure', 'members' => [ 'comment' => [ 'shape' => 'DelegationComment', ], 'controlSetId' => [ 'shape' => 'ControlSetId', ], 'roleArn' => [ 'shape' => 'IamArn', ], 'roleType' => [ 'shape' => 'RoleType', ], ], ], 'CreateDelegationRequests' => [ 'type' => 'list', 'member' => [ 'shape' => 'CreateDelegationRequest', ], 'max' => 50, 'min' => 1, ], 'CreatedBy' => [ 'type' => 'string', 'max' => 100, 'min' => 1, 'pattern' => '^[a-zA-Z0-9\\s-_()\\[\\]]+$', ], 'Delegation' => [ 'type' => 'structure', 'members' => [ 'id' => [ 'shape' => 'UUID', ], 'assessmentName' => [ 'shape' => 'AssessmentName', ], 'assessmentId' => [ 'shape' => 'UUID', ], 'status' => [ 'shape' => 'DelegationStatus', ], 'roleArn' => [ 'shape' => 'IamArn', ], 'roleType' => [ 'shape' => 'RoleType', ], 'creationTime' => [ 'shape' => 'Timestamp', ], 'lastUpdated' => [ 'shape' => 'Timestamp', ], 'controlSetId' => [ 'shape' => 'ControlSetId', ], 'comment' => [ 'shape' => 'DelegationComment', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], ], ], 'DelegationComment' => [ 'type' => 'string', 'max' => 350, 'pattern' => '^[\\w\\W\\s\\S]*$', ], 'DelegationIds' => [ 'type' => 'list', 'member' => [ 'shape' => 'UUID', ], 'max' => 50, 'min' => 1, ], 'DelegationMetadata' => [ 'type' => 'structure', 'members' => [ 'id' => [ 'shape' => 'UUID', ], 'assessmentName' => [ 'shape' => 'AssessmentName', ], 'assessmentId' => [ 'shape' => 'UUID', ], 'status' => [ 'shape' => 'DelegationStatus', ], 'roleArn' => [ 'shape' => 'IamArn', ], 'creationTime' => [ 'shape' => 'Timestamp', ], 'controlSetName' => [ 'shape' => 'NonEmptyString', ], ], ], 'DelegationMetadataList' => [ 'type' => 'list', 'member' => [ 'shape' => 'DelegationMetadata', ], ], 'DelegationStatus' => [ 'type' => 'string', 'enum' => [ 'IN_PROGRESS', 'UNDER_REVIEW', 'COMPLETE', ], ], 'Delegations' => [ 'type' => 'list', 'member' => [ 'shape' => 'Delegation', ], ], 'DeleteAssessmentFrameworkRequest' => [ 'type' => 'structure', 'required' => [ 'frameworkId', ], 'members' => [ 'frameworkId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'frameworkId', ], ], ], 'DeleteAssessmentFrameworkResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteAssessmentReportRequest' => [ 'type' => 'structure', 'required' => [ 'assessmentId', 'assessmentReportId', ], 'members' => [ 'assessmentId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'assessmentId', ], 'assessmentReportId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'assessmentReportId', ], ], ], 'DeleteAssessmentReportResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteAssessmentRequest' => [ 'type' => 'structure', 'required' => [ 'assessmentId', ], 'members' => [ 'assessmentId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'assessmentId', ], ], ], 'DeleteAssessmentResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteControlRequest' => [ 'type' => 'structure', 'required' => [ 'controlId', ], 'members' => [ 'controlId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'controlId', ], ], ], 'DeleteControlResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeregisterAccountRequest' => [ 'type' => 'structure', 'members' => [], ], 'DeregisterAccountResponse' => [ 'type' => 'structure', 'members' => [ 'status' => [ 'shape' => 'AccountStatus', ], ], ], 'DeregisterOrganizationAdminAccountRequest' => [ 'type' => 'structure', 'members' => [ 'adminAccountId' => [ 'shape' => 'AccountId', ], ], ], 'DeregisterOrganizationAdminAccountResponse' => [ 'type' => 'structure', 'members' => [], ], 'DisassociateAssessmentReportEvidenceFolderRequest' => [ 'type' => 'structure', 'required' => [ 'assessmentId', 'evidenceFolderId', ], 'members' => [ 'assessmentId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'assessmentId', ], 'evidenceFolderId' => [ 'shape' => 'UUID', ], ], ], 'DisassociateAssessmentReportEvidenceFolderResponse' => [ 'type' => 'structure', 'members' => [], ], 'EmailAddress' => [ 'type' => 'string', 'max' => 320, 'min' => 1, 'pattern' => '^.*@.*$', ], 'ErrorCode' => [ 'type' => 'string', 'max' => 3, 'min' => 3, 'pattern' => '[0-9]{3}', ], 'ErrorMessage' => [ 'type' => 'string', 'max' => 300, 'pattern' => '^[\\w\\W\\s\\S]*$', ], 'EventName' => [ 'type' => 'string', 'max' => 100, 'pattern' => '^[\\w\\W\\s\\S]*$', ], 'Evidence' => [ 'type' => 'structure', 'members' => [ 'dataSource' => [ 'shape' => 'String', ], 'evidenceAwsAccountId' => [ 'shape' => 'AccountId', ], 'time' => [ 'shape' => 'Timestamp', ], 'eventSource' => [ 'shape' => 'AWSServiceName', ], 'eventName' => [ 'shape' => 'EventName', ], 'evidenceByType' => [ 'shape' => 'String', ], 'resourcesIncluded' => [ 'shape' => 'Resources', ], 'attributes' => [ 'shape' => 'EvidenceAttributes', ], 'iamId' => [ 'shape' => 'IamArn', ], 'complianceCheck' => [ 'shape' => 'String', ], 'awsOrganization' => [ 'shape' => 'String', ], 'awsAccountId' => [ 'shape' => 'AccountId', ], 'evidenceFolderId' => [ 'shape' => 'UUID', ], 'id' => [ 'shape' => 'UUID', ], 'assessmentReportSelection' => [ 'shape' => 'String', ], ], ], 'EvidenceAttributeKey' => [ 'type' => 'string', 'max' => 100, 'pattern' => '^[\\w\\W\\s\\S]*$', ], 'EvidenceAttributeValue' => [ 'type' => 'string', 'max' => 200, 'pattern' => '^[\\w\\W\\s\\S]*$', ], 'EvidenceAttributes' => [ 'type' => 'map', 'key' => [ 'shape' => 'EvidenceAttributeKey', ], 'value' => [ 'shape' => 'EvidenceAttributeValue', ], ], 'EvidenceIds' => [ 'type' => 'list', 'member' => [ 'shape' => 'UUID', ], 'max' => 50, 'min' => 0, ], 'EvidenceList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Evidence', ], ], 'EvidenceSources' => [ 'type' => 'list', 'member' => [ 'shape' => 'NonEmptyString', ], ], 'Filename' => [ 'type' => 'string', 'max' => 255, 'min' => 1, 'pattern' => '^[\\w,\\s-]+\\.[A-Za-z]+$', ], 'Framework' => [ 'type' => 'structure', 'members' => [ 'arn' => [ 'shape' => 'AuditManagerArn', ], 'id' => [ 'shape' => 'UUID', ], 'name' => [ 'shape' => 'FrameworkName', ], 'type' => [ 'shape' => 'FrameworkType', ], 'complianceType' => [ 'shape' => 'ComplianceType', ], 'description' => [ 'shape' => 'FrameworkDescription', ], 'logo' => [ 'shape' => 'Filename', ], 'controlSources' => [ 'shape' => 'ControlSources', ], 'controlSets' => [ 'shape' => 'ControlSets', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'lastUpdatedAt' => [ 'shape' => 'Timestamp', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'lastUpdatedBy' => [ 'shape' => 'LastUpdatedBy', ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'FrameworkDescription' => [ 'type' => 'string', 'max' => 1000, 'min' => 1, 'pattern' => '^[\\w\\W\\s\\S]*$', ], 'FrameworkMetadata' => [ 'type' => 'structure', 'members' => [ 'name' => [ 'shape' => 'AssessmentName', ], 'description' => [ 'shape' => 'AssessmentFrameworkDescription', ], 'logo' => [ 'shape' => 'Filename', ], 'complianceType' => [ 'shape' => 'ComplianceType', ], ], ], 'FrameworkMetadataList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AssessmentFrameworkMetadata', ], ], 'FrameworkName' => [ 'type' => 'string', 'max' => 300, 'min' => 1, 'pattern' => '^[\\w\\W\\s\\S]*$', ], 'FrameworkType' => [ 'type' => 'string', 'enum' => [ 'Standard', 'Custom', ], ], 'GenericArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 20, 'pattern' => '^arn:.*', ], 'GetAccountStatusRequest' => [ 'type' => 'structure', 'members' => [], ], 'GetAccountStatusResponse' => [ 'type' => 'structure', 'members' => [ 'status' => [ 'shape' => 'AccountStatus', ], ], ], 'GetAssessmentFrameworkRequest' => [ 'type' => 'structure', 'required' => [ 'frameworkId', ], 'members' => [ 'frameworkId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'frameworkId', ], ], ], 'GetAssessmentFrameworkResponse' => [ 'type' => 'structure', 'members' => [ 'framework' => [ 'shape' => 'Framework', ], ], ], 'GetAssessmentReportUrlRequest' => [ 'type' => 'structure', 'required' => [ 'assessmentReportId', 'assessmentId', ], 'members' => [ 'assessmentReportId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'assessmentReportId', ], 'assessmentId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'assessmentId', ], ], ], 'GetAssessmentReportUrlResponse' => [ 'type' => 'structure', 'members' => [ 'preSignedUrl' => [ 'shape' => 'URL', ], ], ], 'GetAssessmentRequest' => [ 'type' => 'structure', 'required' => [ 'assessmentId', ], 'members' => [ 'assessmentId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'assessmentId', ], ], ], 'GetAssessmentResponse' => [ 'type' => 'structure', 'members' => [ 'assessment' => [ 'shape' => 'Assessment', ], ], ], 'GetChangeLogsRequest' => [ 'type' => 'structure', 'required' => [ 'assessmentId', ], 'members' => [ 'assessmentId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'assessmentId', ], 'controlSetId' => [ 'shape' => 'ControlSetId', 'location' => 'querystring', 'locationName' => 'controlSetId', ], 'controlId' => [ 'shape' => 'UUID', 'location' => 'querystring', 'locationName' => 'controlId', ], 'nextToken' => [ 'shape' => 'Token', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'GetChangeLogsResponse' => [ 'type' => 'structure', 'members' => [ 'changeLogs' => [ 'shape' => 'ChangeLogs', ], 'nextToken' => [ 'shape' => 'Token', ], ], ], 'GetControlRequest' => [ 'type' => 'structure', 'required' => [ 'controlId', ], 'members' => [ 'controlId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'controlId', ], ], ], 'GetControlResponse' => [ 'type' => 'structure', 'members' => [ 'control' => [ 'shape' => 'Control', ], ], ], 'GetDelegationsRequest' => [ 'type' => 'structure', 'members' => [ 'nextToken' => [ 'shape' => 'Token', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'GetDelegationsResponse' => [ 'type' => 'structure', 'members' => [ 'delegations' => [ 'shape' => 'DelegationMetadataList', ], 'nextToken' => [ 'shape' => 'Token', ], ], ], 'GetEvidenceByEvidenceFolderRequest' => [ 'type' => 'structure', 'required' => [ 'assessmentId', 'controlSetId', 'evidenceFolderId', ], 'members' => [ 'assessmentId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'assessmentId', ], 'controlSetId' => [ 'shape' => 'ControlSetId', 'location' => 'uri', 'locationName' => 'controlSetId', ], 'evidenceFolderId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'evidenceFolderId', ], 'nextToken' => [ 'shape' => 'Token', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'GetEvidenceByEvidenceFolderResponse' => [ 'type' => 'structure', 'members' => [ 'evidence' => [ 'shape' => 'EvidenceList', ], 'nextToken' => [ 'shape' => 'Token', ], ], ], 'GetEvidenceFolderRequest' => [ 'type' => 'structure', 'required' => [ 'assessmentId', 'controlSetId', 'evidenceFolderId', ], 'members' => [ 'assessmentId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'assessmentId', ], 'controlSetId' => [ 'shape' => 'ControlSetId', 'location' => 'uri', 'locationName' => 'controlSetId', ], 'evidenceFolderId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'evidenceFolderId', ], ], ], 'GetEvidenceFolderResponse' => [ 'type' => 'structure', 'members' => [ 'evidenceFolder' => [ 'shape' => 'AssessmentEvidenceFolder', ], ], ], 'GetEvidenceFoldersByAssessmentControlRequest' => [ 'type' => 'structure', 'required' => [ 'assessmentId', 'controlSetId', 'controlId', ], 'members' => [ 'assessmentId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'assessmentId', ], 'controlSetId' => [ 'shape' => 'ControlSetId', 'location' => 'uri', 'locationName' => 'controlSetId', ], 'controlId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'controlId', ], 'nextToken' => [ 'shape' => 'Token', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'GetEvidenceFoldersByAssessmentControlResponse' => [ 'type' => 'structure', 'members' => [ 'evidenceFolders' => [ 'shape' => 'AssessmentEvidenceFolders', ], 'nextToken' => [ 'shape' => 'Token', ], ], ], 'GetEvidenceFoldersByAssessmentRequest' => [ 'type' => 'structure', 'required' => [ 'assessmentId', ], 'members' => [ 'assessmentId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'assessmentId', ], 'nextToken' => [ 'shape' => 'Token', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'GetEvidenceFoldersByAssessmentResponse' => [ 'type' => 'structure', 'members' => [ 'evidenceFolders' => [ 'shape' => 'AssessmentEvidenceFolders', ], 'nextToken' => [ 'shape' => 'Token', ], ], ], 'GetEvidenceRequest' => [ 'type' => 'structure', 'required' => [ 'assessmentId', 'controlSetId', 'evidenceFolderId', 'evidenceId', ], 'members' => [ 'assessmentId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'assessmentId', ], 'controlSetId' => [ 'shape' => 'ControlSetId', 'location' => 'uri', 'locationName' => 'controlSetId', ], 'evidenceFolderId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'evidenceFolderId', ], 'evidenceId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'evidenceId', ], ], ], 'GetEvidenceResponse' => [ 'type' => 'structure', 'members' => [ 'evidence' => [ 'shape' => 'Evidence', ], ], ], 'GetOrganizationAdminAccountRequest' => [ 'type' => 'structure', 'members' => [], ], 'GetOrganizationAdminAccountResponse' => [ 'type' => 'structure', 'members' => [ 'adminAccountId' => [ 'shape' => 'AccountId', ], 'organizationId' => [ 'shape' => 'organizationId', ], ], ], 'GetServicesInScopeRequest' => [ 'type' => 'structure', 'members' => [], ], 'GetServicesInScopeResponse' => [ 'type' => 'structure', 'members' => [ 'serviceMetadata' => [ 'shape' => 'ServiceMetadataList', ], ], ], 'GetSettingsRequest' => [ 'type' => 'structure', 'required' => [ 'attribute', ], 'members' => [ 'attribute' => [ 'shape' => 'SettingAttribute', 'location' => 'uri', 'locationName' => 'attribute', ], ], ], 'GetSettingsResponse' => [ 'type' => 'structure', 'members' => [ 'settings' => [ 'shape' => 'Settings', ], ], ], 'HyperlinkName' => [ 'type' => 'string', 'max' => 200, 'min' => 1, 'pattern' => '^[\\w\\W\\s\\S]*$', ], 'IamArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 20, 'pattern' => '^arn:.*:iam:.*', ], 'Integer' => [ 'type' => 'integer', ], 'InternalServerException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, 'fault' => true, ], 'KeywordInputType' => [ 'type' => 'string', 'enum' => [ 'SELECT_FROM_LIST', ], ], 'KeywordValue' => [ 'type' => 'string', 'max' => 100, 'min' => 1, 'pattern' => '^[a-zA-Z_0-9-\\s().]+$', ], 'Keywords' => [ 'type' => 'list', 'member' => [ 'shape' => 'KeywordValue', ], ], 'KmsKey' => [ 'type' => 'string', 'max' => 2048, 'min' => 7, 'pattern' => '^arn:.*:kms:.*|DEFAULT', ], 'LastUpdatedBy' => [ 'type' => 'string', 'max' => 100, 'min' => 1, 'pattern' => '^[a-zA-Z0-9\\s-_()\\[\\]]+$', ], 'ListAssessmentFrameworksRequest' => [ 'type' => 'structure', 'required' => [ 'frameworkType', ], 'members' => [ 'frameworkType' => [ 'shape' => 'FrameworkType', 'location' => 'querystring', 'locationName' => 'frameworkType', ], 'nextToken' => [ 'shape' => 'Token', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListAssessmentFrameworksResponse' => [ 'type' => 'structure', 'members' => [ 'frameworkMetadataList' => [ 'shape' => 'FrameworkMetadataList', ], 'nextToken' => [ 'shape' => 'Token', ], ], ], 'ListAssessmentMetadata' => [ 'type' => 'list', 'member' => [ 'shape' => 'AssessmentMetadataItem', ], ], 'ListAssessmentReportsRequest' => [ 'type' => 'structure', 'members' => [ 'nextToken' => [ 'shape' => 'Token', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListAssessmentReportsResponse' => [ 'type' => 'structure', 'members' => [ 'assessmentReports' => [ 'shape' => 'AssessmentReportsMetadata', ], 'nextToken' => [ 'shape' => 'Token', ], ], ], 'ListAssessmentsRequest' => [ 'type' => 'structure', 'members' => [ 'nextToken' => [ 'shape' => 'Token', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListAssessmentsResponse' => [ 'type' => 'structure', 'members' => [ 'assessmentMetadata' => [ 'shape' => 'ListAssessmentMetadata', ], 'nextToken' => [ 'shape' => 'Token', ], ], ], 'ListControlsRequest' => [ 'type' => 'structure', 'required' => [ 'controlType', ], 'members' => [ 'controlType' => [ 'shape' => 'ControlType', 'location' => 'querystring', 'locationName' => 'controlType', ], 'nextToken' => [ 'shape' => 'Token', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListControlsResponse' => [ 'type' => 'structure', 'members' => [ 'controlMetadataList' => [ 'shape' => 'ControlMetadataList', ], 'nextToken' => [ 'shape' => 'Token', ], ], ], 'ListKeywordsForDataSourceRequest' => [ 'type' => 'structure', 'required' => [ 'source', ], 'members' => [ 'source' => [ 'shape' => 'SourceType', 'location' => 'querystring', 'locationName' => 'source', ], 'nextToken' => [ 'shape' => 'Token', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListKeywordsForDataSourceResponse' => [ 'type' => 'structure', 'members' => [ 'keywords' => [ 'shape' => 'Keywords', ], 'nextToken' => [ 'shape' => 'Token', ], ], ], 'ListNotificationsRequest' => [ 'type' => 'structure', 'members' => [ 'nextToken' => [ 'shape' => 'Token', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListNotificationsResponse' => [ 'type' => 'structure', 'members' => [ 'notifications' => [ 'shape' => 'Notifications', ], 'nextToken' => [ 'shape' => 'Token', ], ], ], 'ListTagsForResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', ], 'members' => [ 'resourceArn' => [ 'shape' => 'AuditManagerArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], ], ], 'ListTagsForResourceResponse' => [ 'type' => 'structure', 'members' => [ 'tags' => [ 'shape' => 'TagMap', ], ], ], 'ManualEvidence' => [ 'type' => 'structure', 'members' => [ 's3ResourcePath' => [ 'shape' => 'S3Url', ], ], ], 'ManualEvidenceList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ManualEvidence', ], 'max' => 50, 'min' => 1, ], 'MaxResults' => [ 'type' => 'integer', 'max' => 1000, 'min' => 1, ], 'NonEmptyString' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '.*\\S.*', ], 'Notification' => [ 'type' => 'structure', 'members' => [ 'id' => [ 'shape' => 'TimestampUUID', ], 'assessmentId' => [ 'shape' => 'UUID', ], 'assessmentName' => [ 'shape' => 'AssessmentName', ], 'controlSetId' => [ 'shape' => 'ControlSetId', ], 'controlSetName' => [ 'shape' => 'NonEmptyString', ], 'description' => [ 'shape' => 'NonEmptyString', ], 'eventTime' => [ 'shape' => 'Timestamp', ], 'source' => [ 'shape' => 'NonEmptyString', ], ], ], 'Notifications' => [ 'type' => 'list', 'member' => [ 'shape' => 'Notification', ], ], 'ObjectTypeEnum' => [ 'type' => 'string', 'enum' => [ 'ASSESSMENT', 'CONTROL_SET', 'CONTROL', 'DELEGATION', 'ASSESSMENT_REPORT', ], ], 'RegisterAccountRequest' => [ 'type' => 'structure', 'members' => [ 'kmsKey' => [ 'shape' => 'KmsKey', ], 'delegatedAdminAccount' => [ 'shape' => 'AccountId', ], ], ], 'RegisterAccountResponse' => [ 'type' => 'structure', 'members' => [ 'status' => [ 'shape' => 'AccountStatus', ], ], ], 'RegisterOrganizationAdminAccountRequest' => [ 'type' => 'structure', 'required' => [ 'adminAccountId', ], 'members' => [ 'adminAccountId' => [ 'shape' => 'AccountId', ], ], ], 'RegisterOrganizationAdminAccountResponse' => [ 'type' => 'structure', 'members' => [ 'adminAccountId' => [ 'shape' => 'AccountId', ], 'organizationId' => [ 'shape' => 'organizationId', ], ], ], 'Resource' => [ 'type' => 'structure', 'members' => [ 'arn' => [ 'shape' => 'GenericArn', ], 'value' => [ 'shape' => 'String', ], ], ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'required' => [ 'message', 'resourceId', 'resourceType', ], 'members' => [ 'message' => [ 'shape' => 'String', ], 'resourceId' => [ 'shape' => 'String', ], 'resourceType' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], 'Resources' => [ 'type' => 'list', 'member' => [ 'shape' => 'Resource', ], ], 'Role' => [ 'type' => 'structure', 'members' => [ 'roleType' => [ 'shape' => 'RoleType', ], 'roleArn' => [ 'shape' => 'IamArn', ], ], ], 'RoleType' => [ 'type' => 'string', 'enum' => [ 'PROCESS_OWNER', 'RESOURCE_OWNER', ], ], 'Roles' => [ 'type' => 'list', 'member' => [ 'shape' => 'Role', ], ], 'S3Url' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, 'pattern' => '^(S|s)3:\\/\\/[a-zA-Z0-9-_\\/.]+$', ], 'SNSTopic' => [ 'type' => 'string', 'max' => 255, 'min' => 1, 'pattern' => '^[a-zA-Z0-9-_\\(\\)\\[\\]]+$', ], 'Scope' => [ 'type' => 'structure', 'members' => [ 'awsAccounts' => [ 'shape' => 'AWSAccounts', ], 'awsServices' => [ 'shape' => 'AWSServices', ], ], ], 'ServiceMetadata' => [ 'type' => 'structure', 'members' => [ 'name' => [ 'shape' => 'AWSServiceName', ], 'displayName' => [ 'shape' => 'NonEmptyString', ], 'description' => [ 'shape' => 'NonEmptyString', ], 'category' => [ 'shape' => 'NonEmptyString', ], ], ], 'ServiceMetadataList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ServiceMetadata', ], ], 'SettingAttribute' => [ 'type' => 'string', 'enum' => [ 'ALL', 'IS_AWS_ORG_ENABLED', 'SNS_TOPIC', 'DEFAULT_ASSESSMENT_REPORTS_DESTINATION', 'DEFAULT_PROCESS_OWNERS', ], ], 'Settings' => [ 'type' => 'structure', 'members' => [ 'isAwsOrgEnabled' => [ 'shape' => 'Boolean', ], 'snsTopic' => [ 'shape' => 'SNSTopic', ], 'defaultAssessmentReportsDestination' => [ 'shape' => 'AssessmentReportsDestination', ], 'defaultProcessOwners' => [ 'shape' => 'Roles', ], 'kmsKey' => [ 'shape' => 'KmsKey', ], ], ], 'SnsArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 20, 'pattern' => '^arn:.*:sns:.*', ], 'SourceDescription' => [ 'type' => 'string', 'max' => 1000, 'pattern' => '^[\\w\\W\\s\\S]*$', ], 'SourceFrequency' => [ 'type' => 'string', 'enum' => [ 'DAILY', 'WEEKLY', 'MONTHLY', ], ], 'SourceKeyword' => [ 'type' => 'structure', 'members' => [ 'keywordInputType' => [ 'shape' => 'KeywordInputType', ], 'keywordValue' => [ 'shape' => 'KeywordValue', ], ], ], 'SourceName' => [ 'type' => 'string', 'max' => 100, 'min' => 1, ], 'SourceSetUpOption' => [ 'type' => 'string', 'enum' => [ 'System_Controls_Mapping', 'Procedural_Controls_Mapping', ], ], 'SourceType' => [ 'type' => 'string', 'enum' => [ 'AWS_Cloudtrail', 'AWS_Config', 'AWS_Security_Hub', 'AWS_API_Call', 'MANUAL', ], ], 'String' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => '.*', ], 'TagKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '^(?!aws:)[a-zA-Z+-=._:/]+$', ], 'TagKeyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TagKey', ], 'max' => 50, 'min' => 1, ], 'TagMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'TagKey', ], 'value' => [ 'shape' => 'TagValue', ], 'max' => 50, 'min' => 0, ], 'TagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tags', ], 'members' => [ 'resourceArn' => [ 'shape' => 'AuditManagerArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'TagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'TagValue' => [ 'type' => 'string', 'max' => 256, 'min' => 0, 'pattern' => '.{0,255}', ], 'TestingInformation' => [ 'type' => 'string', 'max' => 1000, 'pattern' => '^[\\w\\W\\s\\S]*$', ], 'Timestamp' => [ 'type' => 'timestamp', ], 'TimestampUUID' => [ 'type' => 'string', 'max' => 50, 'min' => 47, 'pattern' => '^[0-9]{10,13}_[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}$', ], 'Token' => [ 'type' => 'string', 'max' => 1000, 'min' => 1, 'pattern' => '^[A-Za-z0-9+\\/=]*$', ], 'TroubleshootingText' => [ 'type' => 'string', 'max' => 1000, 'pattern' => '^[\\w\\W\\s\\S]*$', ], 'URL' => [ 'type' => 'structure', 'members' => [ 'hyperlinkName' => [ 'shape' => 'HyperlinkName', ], 'link' => [ 'shape' => 'UrlLink', ], ], ], 'UUID' => [ 'type' => 'string', 'max' => 36, 'min' => 36, 'pattern' => '^[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}$', ], 'UntagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tagKeys', ], 'members' => [ 'resourceArn' => [ 'shape' => 'AuditManagerArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tagKeys' => [ 'shape' => 'TagKeyList', 'location' => 'querystring', 'locationName' => 'tagKeys', ], ], ], 'UntagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'UpdateAssessmentControlRequest' => [ 'type' => 'structure', 'required' => [ 'assessmentId', 'controlSetId', 'controlId', ], 'members' => [ 'assessmentId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'assessmentId', ], 'controlSetId' => [ 'shape' => 'ControlSetId', 'location' => 'uri', 'locationName' => 'controlSetId', ], 'controlId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'controlId', ], 'controlStatus' => [ 'shape' => 'ControlStatus', ], 'commentBody' => [ 'shape' => 'ControlCommentBody', ], ], ], 'UpdateAssessmentControlResponse' => [ 'type' => 'structure', 'members' => [ 'control' => [ 'shape' => 'AssessmentControl', ], ], ], 'UpdateAssessmentControlSetStatusRequest' => [ 'type' => 'structure', 'required' => [ 'assessmentId', 'controlSetId', 'status', 'comment', ], 'members' => [ 'assessmentId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'assessmentId', ], 'controlSetId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'controlSetId', ], 'status' => [ 'shape' => 'ControlSetStatus', ], 'comment' => [ 'shape' => 'DelegationComment', ], ], ], 'UpdateAssessmentControlSetStatusResponse' => [ 'type' => 'structure', 'members' => [ 'controlSet' => [ 'shape' => 'AssessmentControlSet', ], ], ], 'UpdateAssessmentFrameworkControlSet' => [ 'type' => 'structure', 'members' => [ 'id' => [ 'shape' => 'UUID', ], 'name' => [ 'shape' => 'ControlSetName', ], 'controls' => [ 'shape' => 'CreateAssessmentFrameworkControls', ], ], ], 'UpdateAssessmentFrameworkControlSets' => [ 'type' => 'list', 'member' => [ 'shape' => 'UpdateAssessmentFrameworkControlSet', ], ], 'UpdateAssessmentFrameworkRequest' => [ 'type' => 'structure', 'required' => [ 'frameworkId', 'name', 'controlSets', ], 'members' => [ 'frameworkId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'frameworkId', ], 'name' => [ 'shape' => 'FrameworkName', ], 'description' => [ 'shape' => 'FrameworkDescription', ], 'complianceType' => [ 'shape' => 'ComplianceType', ], 'controlSets' => [ 'shape' => 'UpdateAssessmentFrameworkControlSets', ], ], ], 'UpdateAssessmentFrameworkResponse' => [ 'type' => 'structure', 'members' => [ 'framework' => [ 'shape' => 'Framework', ], ], ], 'UpdateAssessmentRequest' => [ 'type' => 'structure', 'required' => [ 'assessmentId', 'scope', ], 'members' => [ 'assessmentId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'assessmentId', ], 'assessmentName' => [ 'shape' => 'AssessmentName', ], 'assessmentDescription' => [ 'shape' => 'AssessmentDescription', ], 'scope' => [ 'shape' => 'Scope', ], 'assessmentReportsDestination' => [ 'shape' => 'AssessmentReportsDestination', ], 'roles' => [ 'shape' => 'Roles', ], ], ], 'UpdateAssessmentResponse' => [ 'type' => 'structure', 'members' => [ 'assessment' => [ 'shape' => 'Assessment', ], ], ], 'UpdateAssessmentStatusRequest' => [ 'type' => 'structure', 'required' => [ 'assessmentId', 'status', ], 'members' => [ 'assessmentId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'assessmentId', ], 'status' => [ 'shape' => 'AssessmentStatus', ], ], ], 'UpdateAssessmentStatusResponse' => [ 'type' => 'structure', 'members' => [ 'assessment' => [ 'shape' => 'Assessment', ], ], ], 'UpdateControlRequest' => [ 'type' => 'structure', 'required' => [ 'controlId', 'name', 'controlMappingSources', ], 'members' => [ 'controlId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'controlId', ], 'name' => [ 'shape' => 'ControlName', ], 'description' => [ 'shape' => 'ControlDescription', ], 'testingInformation' => [ 'shape' => 'TestingInformation', ], 'actionPlanTitle' => [ 'shape' => 'ActionPlanTitle', ], 'actionPlanInstructions' => [ 'shape' => 'ActionPlanInstructions', ], 'controlMappingSources' => [ 'shape' => 'ControlMappingSources', ], ], ], 'UpdateControlResponse' => [ 'type' => 'structure', 'members' => [ 'control' => [ 'shape' => 'Control', ], ], ], 'UpdateSettingsRequest' => [ 'type' => 'structure', 'members' => [ 'snsTopic' => [ 'shape' => 'SnsArn', ], 'defaultAssessmentReportsDestination' => [ 'shape' => 'AssessmentReportsDestination', ], 'defaultProcessOwners' => [ 'shape' => 'Roles', ], 'kmsKey' => [ 'shape' => 'KmsKey', ], ], ], 'UpdateSettingsResponse' => [ 'type' => 'structure', 'members' => [ 'settings' => [ 'shape' => 'Settings', ], ], ], 'UrlLink' => [ 'type' => 'string', 'max' => 8192, 'min' => 1, 'pattern' => '^(https?:\\/\\/)?(www\\.)?[a-zA-Z0-9-_]+([\\.]+[a-zA-Z]+)+[\\/\\w]*$', ], 'Username' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '^[a-zA-Z0-9-_()\\s\\+=,.@]+$', ], 'ValidateAssessmentReportIntegrityRequest' => [ 'type' => 'structure', 'required' => [ 's3RelativePath', ], 'members' => [ 's3RelativePath' => [ 'shape' => 'S3Url', ], ], ], 'ValidateAssessmentReportIntegrityResponse' => [ 'type' => 'structure', 'members' => [ 'signatureValid' => [ 'shape' => 'Boolean', ], 'signatureAlgorithm' => [ 'shape' => 'String', ], 'signatureDateTime' => [ 'shape' => 'String', ], 'signatureKeyId' => [ 'shape' => 'String', ], 'validationErrors' => [ 'shape' => 'ValidationErrors', ], ], ], 'ValidationErrors' => [ 'type' => 'list', 'member' => [ 'shape' => 'NonEmptyString', ], ], 'ValidationException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], 'reason' => [ 'shape' => 'ValidationExceptionReason', ], 'fields' => [ 'shape' => 'ValidationExceptionFieldList', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'ValidationExceptionField' => [ 'type' => 'structure', 'required' => [ 'name', 'message', ], 'members' => [ 'name' => [ 'shape' => 'String', ], 'message' => [ 'shape' => 'String', ], ], ], 'ValidationExceptionFieldList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ValidationExceptionField', ], ], 'ValidationExceptionReason' => [ 'type' => 'string', 'enum' => [ 'unknownOperation', 'cannotParse', 'fieldValidationFailed', 'other', ], ], 'organizationId' => [ 'type' => 'string', 'max' => 34, 'min' => 12, 'pattern' => 'o-[a-z0-9]{10,32}', ], ],];
