<?php

namespace Themes\Cynoebook\Http\Requests;

use Modules\Base\Http\Requests\Request;

class SaveCynoebookRequest extends Request
{
    /**
     * Array of attributes that should be merged with null
     * if attribute is not found in the current request.
     *
     * @var array
     */
    private $shouldCheck = [
        'cynoebook_ebook_carousel_section_ebooks',
    ];

    /**
     * Get data to be validated from the request.
     *
     * @return array
     */
    public function validationData()
    {
        foreach ($this->shouldCheck as $attribute) {
            if (! $this->has($attribute)) {
                $this->merge([$attribute => null]);
            }
        }

        return $this->all();
    }
}
